----------------------------------------------------------------------------------------------------
-- Tutorial 13: Create Link Pack Resource Container NKR
----------------------------------------------------------------------------------------------------
--[[

--]]

local fs = Filesystem

-- Reset Kontakt rack.
Kontakt.reset_multi()

-- We would like to save our instrument. We prepare a folder where we will save it.
local save_base_path = fs.preferred(Kontakt.script_path .. "/Generated")

-- Some error handling, if this folder does not exist, create it.
if not fs.exists(save_base_path) then fs.create_directory(save_base_path) end

-- A subflder for this tutorial.
save_base_path = fs.preferred(save_base_path .. "/resource_container_test")

-- Some error handling, if this folder does not exist, create it.
if not fs.exists(save_base_path) then fs.create_directory(save_base_path) end

-- Add a new instrument.
local instrument = Kontakt.add_instrument()

-- Save the instrument in with the path.
Kontakt.save_instrument(instrument, fs.preferred(save_base_path .. "/instrument.nki"))

-- Create the resource container NKR file and bind the NKI to it.
-- If the folder structure does not exist it is created, otherwise it is kept.
-- If files have been changed, the NKR is repacked.
Kontakt.create_resource_container(instrument, fs.preferred(save_base_path .. "/instrument.nkr"))
